<?php
require_once __DIR__ . '/../config/db.php';
$stmt = $pdo->query('SELECT * FROM events WHERE status=1 ORDER BY date ASC');
$events = $stmt->fetchAll();
?>
<!doctype html><html><head><meta charset="utf-8"><title>Event List</title>
<link rel="stylesheet" href="../assets/css/style.css">
</head><body>
<h2>Event List</h2>
<?php foreach($events as $e): ?>
  <div class="event-row">
    <div class="day-box"><?php echo date('D d', strtotime($e['date'])); ?></div>
    <div class="title"><a href="#" class="openEvent" data-id="<?php echo $e['id']; ?>"><?php echo htmlspecialchars($e['name']); ?></a></div>
  </div>
<?php endforeach; ?>

<div id="modal" style="display:none; position:fixed; left:50%; top:20%; transform:translateX(-50%); background:#fff; padding:20px; border:1px solid #ccc; z-index:9999; max-width:600px;"></div>

<script>
document.querySelectorAll('.openEvent').forEach(function(el){
  el.addEventListener('click', function(ev){
    ev.preventDefault();
    var id = this.dataset.id;
    fetch('/events/api/get_event.php?id=' + id).then(r=>r.json()).then(data=>{
      if(data.success){
        var e = data.event;
        document.getElementById('modal').innerHTML = '<h3>'+e.name+'</h3><p>'+e.date+'</p><div>'+ (e.content?e.content:'') +'</div><button onclick="document.getElementById(\'modal\').style.display=\'none\'">Close</button>';
        document.getElementById('modal').style.display = 'block';
      }
    });
  });
});
</script>
</body></html>
